#!/bin/sh

printf "\nCalling Refresh API...\n\n"

srsType=$1
# Ensure CATALINA_HOME is set
if [ -z "$CATALINA_HOME" ]; then
    SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
    CATALINA_HOME="$(cd "$SCRIPT_DIR/.." && pwd)"
fi

#printf "input arg = $srsType \n\n"
# Determine application.yml location
if [ -n "$SRS_CONF_FILE" ]; then
    app_yml="$SRS_CONF_FILE"
else
    app_yml="$CATALINA_HOME/conf/application.yml"
fi

apiKey=$(grep apiKey "$app_yml"|sed 's/^.*: //')
siteCode=$(grep siteCode "$app_yml"|sed 's/^.*: //')

siteCode=$(echo "$siteCode" | tr -d '\r\n')
apiKey=$(echo "$apiKey" | tr -d '\r\n')
#printf "apiKey = $apiKey"
#printf "\n\n"
#printf "siteCode = $siteCode"
#printf "\n\n"

port=8080
port=$(grep 'Connector port=' "$CATALINA_HOME/conf/server.xml" | grep -v "redirectPort" | head -n 1 | sed -n 's/.*port="\([0-9]*\)".*/\1/p')


##set curl
if [[ $srsType == "outbound" ]]; then
	printf "refreshing outbound ...\n\n"
	curl --location --request GET 'http://localhost:'$port'/rxoutbound/management/refresh' -u "${siteCode}:${apiKey}" >> $CATALINA_HOME/logs/pdmp-refresh.log
	echo -en "\n" >> $CATALINA_HOME/logs/pdmp-refresh.log
	
elif [[ $srsType == "inbound" ]]; then
	printf "refreshing inbound ...\n\n"
	curl --location --request GET 'http://localhost:'$port'/rxinbound/management/refresh' -u "${siteCode}:${apiKey}" >> $CATALINA_HOME/logs/pdmp-refresh.log
	echo -en "\n" >> $CATALINA_HOME/logs/pdmp-refresh.log
else
	printf "refreshing outbound...\n\n"
	curl --location --request GET 'http://localhost:'$port'/rxoutbound/management/refresh' -u "${siteCode}:${apiKey}" >> $CATALINA_HOME/logs/pdmp-refresh.log
	echo -en "\n" >> $CATALINA_HOME/logs/pdmp-refresh.log
	
	printf "refreshing inbound...\n\n"
        curl --location --request GET 'http://localhost:'$port'/rxinbound/management/refresh' -u "${siteCode}:${apiKey}" >> $CATALINA_HOME/logs/pdmp-refresh.log
	echo -en "\n" >> $CATALINA_HOME/logs/pdmp-refresh.log
fi

#curl --location --request GET 'http://localhost:'$port'/rxoutbound/management/refresh' -u $siteCode:$apiKey >> ../logs/pdmp-refresh.log

##printf "\n\n"
##printf "\n\nRefresh API call successfull!\n\n"

