@echo off

rem ******************~~~~~~PDMP Refresh Script~~~~~~*******************
rem                                                                    
rem Developer: Addvait Jhaveri                                        
rem                                                                    
rem Creation Date: 05/03/2022                                            
rem                                                                    
rem Description: Refresh script to call refresh api for                
rem              outbound and/or inbound.                              
rem              Pass outbound as argument to execute outbound refresh 
rem              Pass inbound as argument to execute inbound refresh   
rem              If no argument is passed to the script both           
rem              outbound and inbound will be refreshed                
rem                                                                    
rem ********************************************************************

SETLOCAL
SETLOCAL ENABLEDELAYEDEXPANSION

echo Calling Refresh API...

set srsType=%1

FOR /F "tokens=2,2 delims=: " %%A IN ('findstr /i "siteCode" ..\conf\application.yml') DO (
    set siteCode=%%A
)

::echo siteCode: %siteCode%

FOR /F "tokens=2,2 delims=: " %%B IN ('findstr /i "apiKey" ..\conf\application.yml') DO (
	set apiKey=%%B
)

::echo apiKey: %apiKey%

SETLOCAL ENABLEDELAYEDEXPANSION

FOR /F "tokens=2,3 delims==" %%C IN ('findstr /i "<Connector" ..\conf\server.xml') DO (
	set x=%%C 
	set y=%%D
	set str=abc
	If NOT "!y!"=="!y:HTTP/=!" (
		If NOT "!y!" == "" (
			set portStr=!x!
			goto break
		)
	)
)
:break

SETLOCAL DISABLEDELAYEDEXPANSION

FOR /F %%p in ('powershell.exe -noprofile -c "('%portStr:"=\"%' -split '\""')[1]"') do set port=%%p

::echo port %port%

set "user=%siteCode%"
set "pass=%apiKey%"

set "pair=%user%:%pass%"

FOR /F "delims=" %%I in (
    'powershell "[convert]::ToBase64String([Text.Encoding]::UTF8.GetBytes(\"%pair%\"))"'
) do set "VAR=%%I"

::echo %VAR%

IF /I "%srsType%" == "outbound" ( 
	echo Executing outbound refresh api...
	powershell.exe -command  "& Invoke-WebRequest -Uri 'http://localhost:%port%/rxoutbound/management/refresh' -Headers @{Authorization="\"Basic %VAR%\""} >> ..\logs\pdmp-refresh.log
) ELSE (
	IF /I "%srsType%" == "inbound" ( 
		echo Executing inbound refresh api...
		powershell.exe -command  "& Invoke-WebRequest -Uri 'http://localhost:%port%/rxinbound/management/refresh' -Headers @{Authorization="\"Basic %VAR%\""} >> ..\logs\pdmp-refresh.log
	) ELSE (
		echo Executing outbound refresh api...
		powershell.exe -command  "& Invoke-WebRequest -Uri 'http://localhost:%port%/rxoutbound/management/refresh' -Headers @{Authorization="\"Basic %VAR%\""} >> ..\logs\pdmp-refresh.log
		echo Executing inbound refresh api...
		powershell.exe -command  "& Invoke-WebRequest -Uri 'http://localhost:%port%/rxinbound/management/refresh' -Headers @{Authorization="\"Basic %VAR%\""} >> ..\logs\pdmp-refresh.log
	)
) 

::PAUSE
::TIMEOUT 10